#include <stdio.h>
#include <stdlib.h>

void merge(int arr[], int l, int m, int r) {
  int i, j, k;
  int n1 = m - l + 1;
  int n2 = r - m;

  int L[n1], R[n2];

  for (i = 0; i < n1; i++)
    L[i] = arr[l + i];
  for (j = 0; j < n2; j++)
    R[j] = arr[m + 1 + j];

  i = 0;
  j = 0;
  k = l;
  while (i < n1 && j < n2) {
    if (L[i] <= R[j]) {
      arr[k] = L[i];
      i++;
    } else {
      arr[k] = R[j];
      j++;
    }
    k++;
  }

  while (i < n1) {
    arr[k] = L[i];
    i++;
    k++;
  }

  while (j < n2) {
    arr[k] = R[j];
    j++;
    k++;
  }
}

void mergeSort(int arr[], int l, int r) {
  if (l < r) {
    int m = l + (r - l) / 2;
    mergeSort(arr, l, m);
    mergeSort(arr, m + 1, r);
    merge(arr, l, m, r);
  }
}

int lower_bound(int arr[], int N, int X) {
  int mid;
  int low = 0;
  int high = N;

  while (low < high) {
    mid = low + (high - low) / 2;

    if (X <= arr[mid]) {
      high = mid;
    }

    else {
      low = mid + 1;
    }
  }

  if (low < N && arr[low] < X) {
    low++;
  }
  return low;
}

int upper_bound(int arr[], int N, int X) {
  int mid;

  int low = 0;
  int high = N;

  while (low < high) {
    mid = low + (high - low) / 2;

    if (X >= arr[mid]) {
      low = mid + 1;
    }

    else {
      high = mid;
    }
  }

  if (low < N && arr[low] <= X) {
    low++;
  }
  return low;
}

int main() {
  int N, Q;
  scanf("%d%d", &N, &Q);
  int A[N], B[Q];
  for (int i = 0; i < N; i++)
    scanf("%d", &A[i]);
  for (int i = 0; i < Q; i++)
    scanf("%d", &B[i]);
  mergeSort(A, 0, N - 1);
  for (int i = 0; i < Q; i++) {
    if (A[N / 2] < B[i]) {
      int k = lower_bound(A, N, B[i]);
      if (k == N) {
        printf("%d\n", N);
      } else {
        int r = 2 * k - N;
        printf("%d\n", r);
      }
    } else if (A[N / 2] > B[i]) {
      int k = upper_bound(A, N, B[i]);
      if (k == N) {
        printf("%d\n", N);
      } else {
        int r = N - 2 * k + 1;
        printf("%d\n", r);
      }
    } else {
      printf("0\n");
    }
  }
  return 0;
}